//AWT Graphics library
import java.awt.*; 
import java.awt.event.*; 
import javax.swing.*;
import java.math.*;
import java.awt.geom.*; 

//The Frame class
class Frame extends JFrame
{
   //Canvas holds all the power values text
   GCanvas canvas;

   //Serial port chooser combo box
   JComboBox availablePorts;

   //Action listner for frame elements
   ActionListener a;

   //Button used to start communication
   Button start;

   //Analog select buttons
   Button a0,a1,a2,a3,a4,a5;

   Button redraw;

   public Container con;

   public Frame()
   {

      super("EnergyLogger"); 

      

      setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

      con = this.getContentPane();

      //We're using absoulute positions layout
      setLayout(null);  

      a = new MyActionListener();

      availablePorts = new JComboBox();

      //Sets-up the Start button
      start = new Button( "Start" );
      start.setActionCommand("start"); 
      start.addActionListener(a); 

      //Choose port label
      Label label1 = new Label("Choose port: ");

      //Refresh button
      Button refresh = new Button("Refresh");
      refresh.setActionCommand("refresh"); 
      refresh.addActionListener(a); 

      //Take Samples buttons
      Label sampleLabel = new Label("Take a Sample: ");

      //ADC prefix 128
      Button s128 = new Button("S128");
      s128.setActionCommand("S128"); 
      s128.addActionListener(a); 
      //ADC prefix 64
      Button s64 = new Button("S64");
      s64.setActionCommand("S64"); 
      s64.addActionListener(a); 
      //ADC prefix 32
      Button s32 = new Button("S32");
      s32.setActionCommand("S32"); 
      s32.addActionListener(a); 
      //ADC prefix 16
      Button s16 = new Button("S16");
      s16.setActionCommand("S16"); 
      s16.addActionListener(a); 

      Label analogLabel = new Label("Select analog inputs: ");
      //Analog input button chooser
      //A0
      a0 = new Button("A0");
      a0.setActionCommand("A0OFF"); 
      a0.addActionListener(a); 
      //A1
      a1 = new Button("A1");
      a1.setActionCommand("A1ON"); 
      a1.addActionListener(a); 
      //A2
      a2 = new Button("A2");
      a2.setActionCommand("A2ON"); 
      a2.addActionListener(a); 
      //A3
      a3 = new Button("A3");
      a3.setActionCommand("A3ON"); 
      a3.addActionListener(a); 
      //A4
      a4 = new Button("A4");
      a4.setActionCommand("A4ON"); 
      a4.addActionListener(a); 
      //A5
      a5 = new Button("A5");
      a5.setActionCommand("A5ON"); 
      a5.addActionListener(a); 

      redraw = new Button("Redraw");
      redraw.setActionCommand("redraw"); 
      redraw.addActionListener(a); 

      //Add the elements
      add(label1);
      add(refresh);
      add(availablePorts);
      add(start);

      //Take sample buttons
      add(sampleLabel);
      add(s128);
      add(s64);
      add(s32);
      add(s16);

      //Take sample buttons
      add(analogLabel);
      add(a0);
      add(a1);
      add(a2);
      add(a3);
      add(a4);
      add(a5);

      add(redraw);

      //Element positioning 
      Insets insets = con.getInsets();

      //The label
      label1.setBounds(5 + insets.left, 8 + insets.top, 150, 26);
      //The refresh button
      refresh.setBounds(160 + insets.left, 12 + insets.top, 60, 20);
      //The port chooser
      Dimension size = availablePorts.getPreferredSize();
      availablePorts.setBounds(5 + insets.left, 35 + insets.top, 215, size.height);
      //The start button
      size = start.getPreferredSize();
      start.setBounds(225 + insets.left, 35 + insets.top, 60, 28);

      sampleLabel.setBounds(5 + insets.left, 70 + insets.top, 150, 26);
     s128.setBounds(0+5 + insets.left, 100 + insets.top, 50, 25);
      s64.setBounds(50+10 + insets.left, 100 + insets.top, 50, 25);
      s32.setBounds(100+15 + insets.left, 100 + insets.top, 50, 25);
      s16.setBounds(150+20 + insets.left, 100 + insets.top, 50, 25);

      analogLabel.setBounds(5 + insets.left, 130 + insets.top, 150, 20);
      a0.setBounds(0+5 + insets.left, 150 + insets.top, 30, 25);
      a1.setBounds(30+10 + insets.left, 150 + insets.top, 30, 25);
      a2.setBounds(60+15 + insets.left, 150 + insets.top, 30, 25);
      a3.setBounds(90+20 + insets.left, 150 + insets.top, 30, 25);
      a4.setBounds(120+25 + insets.left, 150 + insets.top, 30, 25);
      a5.setBounds(150+30 + insets.left, 150 + insets.top, 30, 25);

      redraw.setBounds(5 + insets.left, 200 + insets.top, 50, 25);

   }

}

//Action listener method for the frame elements.
class MyActionListener implements ActionListener 
{ 
   public void actionPerformed(ActionEvent ae) 
   {

      String s = ae.getActionCommand(); 

      if (s.equals("start")) {

      String portname = (String)Program.myFrame.availablePorts.getSelectedItem();

      Program.myArduino.closeSerialPort(); 
      Program.myArduino.start(portname);
      //Change the start button to a stop button, now that the communication is going.
      Program.myFrame.start.setLabel("stop");
      Program.myFrame.start.setActionCommand("stop"); 
}

      if (s.equals("stop")) 
      {

         Program.myArduino.closeSerialPort(); 
         //Change the button back to a stop button
         Program.myFrame.start.setLabel("start");
         Program.myFrame.start.setActionCommand("start"); 
         //Refresh the available ports list, avoids error of selecting port that doesnt exist next time start is clicked
         Program.myFrame.availablePorts.removeAllItems();
         Program.myArduino.listPorts();

      }

      //Refreshes the ports list, useful when plugging in and out usb's
      if (s.equals("refresh"))
      {
         Program.myFrame.availablePorts.removeAllItems();
         Program.myArduino.listPorts();
      }


      if (s.equals("redraw")) Program.update();

      //Refreshes the ports list, useful when plugging in and out usb's
      if (s.equals("S128")) Program.myArduino.sendCommand("S128");
      if (s.equals("S64")) Program.myArduino.sendCommand("S64");
      if (s.equals("S32")) Program.myArduino.sendCommand("S32");
      if (s.equals("S16")) Program.myArduino.sendCommand("S16");
 
      if (s.equals("A0ON")) {Program.myArduino.sendCommand("A0ON"); Program.myFrame.a0.setActionCommand("A0OFF");}
      if (s.equals("A1ON")) {Program.myArduino.sendCommand("A1ON"); Program.myFrame.a1.setActionCommand("A1OFF");}
      if (s.equals("A2ON")) {Program.myArduino.sendCommand("A2ON"); Program.myFrame.a2.setActionCommand("A2OFF");}
      if (s.equals("A3ON")) {Program.myArduino.sendCommand("A3ON"); Program.myFrame.a3.setActionCommand("A3OFF");}
      if (s.equals("A4ON")) {Program.myArduino.sendCommand("A4ON"); Program.myFrame.a4.setActionCommand("A4OFF");}
      if (s.equals("A5ON")) {Program.myArduino.sendCommand("A5ON"); Program.myFrame.a5.setActionCommand("A5OFF");}

      if (s.equals("A0OFF")) {Program.myArduino.sendCommand("A0OFF"); Program.myFrame.a0.setActionCommand("A0ON");}
      if (s.equals("A1OFF")) {Program.myArduino.sendCommand("A1OFF"); Program.myFrame.a1.setActionCommand("A1ON");}
      if (s.equals("A2OFF")) {Program.myArduino.sendCommand("A2OFF"); Program.myFrame.a2.setActionCommand("A2ON");}
      if (s.equals("A3OFF")) {Program.myArduino.sendCommand("A3OFF"); Program.myFrame.a3.setActionCommand("A3ON");}
      if (s.equals("A4OFF")) {Program.myArduino.sendCommand("A4OFF"); Program.myFrame.a4.setActionCommand("A4ON");}
      if (s.equals("A5OFF")) {Program.myArduino.sendCommand("A5OFF"); Program.myFrame.a5.setActionCommand("A5ON");}

      

   } 
} 


class GCanvas extends Canvas
{
   Dimension offDimension;
   Image offImage;
   public Graphics offGraphics;

   //Java Frame buffer stuff
   public void update(Graphics g) {g.drawImage(offImage, 0, 0, null);}

   public void startDraw()
   {
      Dimension d = size();

      // Create the offscreen graphics context
      if ((offGraphics == null)
         || (d.width != offDimension.width)
	 || (d.height != offDimension.height)) 
         {
	    offDimension = d;
	    offImage = createImage(d.width, d.height);
	    offGraphics = offImage.getGraphics();
	 }

      repaint();
   }
   public void paint(Graphics g) 
   {
      if (offImage != null) 
      {
         g.drawImage(offImage, 0, 0, null);
      }
   }
} 

class Graph extends Canvas
{

   public Graphics gCon;
   public int x,y,width,height;
   public double xmin,xmax,ymin,ymax;
   
   public String title;
   public int select=0;

   public Graph(String _title,int _x,int _y,int _width, int _height)
   {
      x=_x; y=_y; width=_width; height=_height;
      title = _title;
   }
  
   public void drawGraph()
   {
      if (gCon!=null)
      {
         gCon.setColor(Color.white);
         gCon.fillRect(x, y, width, height);

         gCon.setColor(new Color(0.0f,0.0f,0.0f)); 
         gCon.drawString(title,x+5,y+15); 
      }

      drawAxis();
   }

   //This lays out and draws each value + descriptive bits
   public void drawText(String title, Double value, String units, int xa,int ya)
   {
      if (gCon!= null)
      {
         //gCon.setFont(new Font("Arial", Font.PLAIN, 12));
         gCon.drawString(title,x+xa,y+ya);
        //gCon.setFont(new Font("Arial", Font.PLAIN, 28));
         gCon.drawString(String.format("%.2f%n", value)+units,x+xa,y+ya+20);
      }
   }

   public void drawAxis()
   {
      if (gCon!=null)
      {
         gCon.setColor(new Color(0.5f,0.5f,0.5f));
          
         int xaxis = graphToScreenX(0.0);
         int yaxis = graphToScreenY(0.0);

         if (pointInBounds(xaxis,y+5)) gCon.drawLine(xaxis,y,xaxis,y+height-1);
         if (pointInBounds(x+5,yaxis)) gCon.drawLine(x,yaxis,x+width-1,yaxis);
         
      }
   }

   public void xAxisRange(int _xmin,int _xmax)
   {
      xmin = _xmin;
      xmax = _xmax;
   }

   public void yAxisRange(double _ymin,double _ymax)
   {
      ymin = _ymin;
      ymax = _ymax;
   }

   //Plots a graph of the y-vector vs array index
   public void indexPlot(DataSet set)
   {  

      double vx=0,vy=0,lvx=0,lvy=0;

      gCon.setColor(new Color(1.0f,0.5f,0.0f)); 
      for (int i=0; i<set.staticIndex; i++)
      {
         lvx=vx; lvy=vy;
         vx = graphToScreenX(i);
         
         vy = graphToScreenY(1.0*set.vector[i]);

         if (i==0){ lvx=vx; lvy=vy;}

         if (pointInBounds((int)vx,(int)vy) && pointInBounds((int)lvx,(int)lvy))
         {
            gCon.drawLine((int)vx,(int)vy,(int)lvx,(int)lvy);
         }
      }

   }

   public int graphToScreenX(double xgraph)
   {
      double dx = width/(xmax-xmin-1);
      int xscreen = (int)(x+(-xmin*dx)+(xgraph*dx));
      
      return xscreen;
   }

   public int graphToScreenY(double ygraph)
   {
      
      double dy = height/(ymax-ymin-1);
      int yscreen = (int)((y+height)-(-ymin*dy)-(ygraph*dy));
      
      return yscreen;
   }

   public void movex(int mx)
   {
      double dx = width/(xmax-xmin-1);
      
      xmin = xmin - (mx / dx);
      xmax = xmax - (mx / dx);

   }

   public void movey(int my)
   {
      double dy = height/(ymax-ymin);
      
      ymin = ymin + (my / dy);
      ymax = ymax + (my / dy);

   }

   public void zoomx(double scale)
   {
      double cRange = xmax - xmin;
      double mid = xmax - cRange / 2.0;
      xmax = mid+(xmax-mid)*scale;
      xmin = mid-(mid-xmin)*scale;
   }

   public void zoomy(double scale)
   {
      double cRange = ymax - ymin;
      double mid = ymax - cRange / 2.0;
      ymax = mid+(ymax-mid)*scale;
      ymin = mid-(mid-ymin)*scale;
   }

   public boolean pointInBounds(int mx,int my)
   {
      boolean result = false;

      if (((mx>x) && (mx<(x+width))) && ((my>y) && (my<(y+height)))) result = true;
    
      return result;
   }

   public void select()
   {

      select = 1;
      gCon.setColor(new Color(0.8f,0.8f,0.8f)); 
      gCon.drawLine(x,y,x+width-1,y);
      gCon.drawLine(x,y+height-1,x+width-1,y+height-1);
      gCon.drawLine(x,y,x,y+height-1);
      gCon.drawLine(x+width-1,y,x+width-1,y+height-1);
   }

   public void deselect()
   {
      select = 0;
   }

}
